<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'domain' OR empty($_REQUEST['action']))
{
	print_cp_header($vbphrase['dbtech_downloads_domain_management']);
	
	// Table header
	$headings = array();
	$headings[] = $vbphrase['dbtech_downloads_domain_name'];
	$headings[] = $vbphrase['description'];
	$headings[] = $vbphrase['active'];
	$headings[] = $vbphrase['edit'];
	$headings[] = $vbphrase['delete'];
	
	
	if (count(VBDOWNLOADS::$cache['domain']))
	{
		print_form_header('vbdownloads', 'domain');	
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_downloads_domain_management'], count($headings));
		print_description_row($vbphrase['dbtech_downloads_domain_management_descr'], false, count($headings));	
		print_cells_row($headings, 0, 'thead');
		
		foreach (VBDOWNLOADS::$cache['domain'] as $domainid => $domain)
		{
			// Table data
			$cell = array();
			$cell[] = $domain['domain'];
			$cell[] = '<img src="' . (substr($domain['image'], 0, 2) == './' ? '.' : '') . $domain['image'] . '" />';
			$cell[] = ($domain['active'] ? $vbphrase['yes'] : '<span class="col-i"><strong>' . $vbphrase['no'] . '</strong></span>');
			$cell[] = construct_link_code($vbphrase['edit'], 'vbdownloads.php?' . $vbulletin->session->vars['sessionurl'] . 'do=domain&amp;action=modify&amp;domainid=' . $domainid);
			$cell[] = construct_link_code($vbphrase['delete'], 'vbdownloads.php?' . $vbulletin->session->vars['sessionurl'] . 'do=domain&amp;action=delete&amp;domainid=' . $domainid);
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
		print_submit_row($vbphrase['dbtech_downloads_add_new_domain'], false, count($headings));
	}
	else
	{
		print_form_header('vbdownloads', 'domain');	
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_downloads_domain_management'], count($headings));
		print_description_row($vbphrase['dbtech_downloads_no_domains'], false, count($headings));
		print_submit_row($vbphrase['dbtech_downloads_add_new_domain'], false, count($headings));	
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$domainid = $vbulletin->input->clean_gpc('r', 'domainid', TYPE_UINT);
	$domain = ($domainid ? VBDOWNLOADS::$cache['domain'][$domainid] : false);
	
	if (!is_array($domain))
	{
		// Non-existing domain
		$domainid = 0;
	}
	
	$defaults = array(
		'domain' 		=> 'dropbox.com',
		'image' 		=> './dbtech/downloads/images/noimage.png',
		'active' 		=> 1,
	);
	
	if ($domainid)
	{
		// Edit
		print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_downloads_editing_x_y'], $vbphrase['dbtech_downloads_domain'], $domain['domain'])));
		print_form_header('vbdownloads', 'domain');
		construct_hidden_code('action', 'update');
		construct_hidden_code('domainid', $domainid);
		print_table_header(construct_phrase($vbphrase['dbtech_downloads_editing_x_y'], $vbphrase['dbtech_downloads_domain'], $domain['domain']));
	}
	else
	{
		// Add
		print_cp_header($vbphrase['dbtech_downloads_add_new_domain']);
		print_form_header('vbdownloads', 'domain');
		construct_hidden_code('action', 'update');
		print_table_header($vbphrase['dbtech_downloads_add_new_domain']);
		
		$domain = $defaults;
	}
	
	print_description_row($vbphrase['dbtech_downloads_main_settings'], false, 2, 'optiontitle');	
	print_input_row($vbphrase['dbtech_downloads_replacement_domain'], 	'domain[domain]', 	$domain['domain']);
	print_input_row($vbphrase['dbtech_downloads_replacement_image'], 	'domain[image]', 	$domain['image']);
	print_yes_no_row($vbphrase['active'],								'domain[active]',	$domain['active']);
	print_submit_row(($domainid ? $vbphrase['save'] : $vbphrase['dbtech_downloads_add_new_domain']));
}

// #############################################################################
if ($_REQUEST['action'] == 'update')
{
	// Grab stuff
	$vbulletin->input->clean_array_gpc('p', array(
		'domainid' 	=> TYPE_UINT,
		'domain' 		=> TYPE_ARRAY,
	));
	
	// init data manager
	$dm =& VBDOWNLOADS::initDataManager('Domain', $vbulletin, ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['domainid'])
	{
		if (!$existing = VBDOWNLOADS::$cache['domain'][$vbulletin->GPC['domainid']])
		{
			// Couldn't find the domain
			print_stop_message('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_domain'], $vbulletin->GPC['domainid']);
		}
		
		// Set existing
		$dm->set_existing($existing);
				
		// Added
		$phrase = $vbphrase['dbtech_downloads_edited'];
	}
	else
	{
		// Added
		$phrase = $vbphrase['dbtech_downloads_added'];
	}
	
	// domain fields
	foreach ($vbulletin->GPC['domain'] AS $key => $val)
	{
		if (!$vbulletin->GPC['domainid'] OR $existing[$key] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	// Save! Hopefully.
	$dm->save();
		
	define('CP_REDIRECT', 'vbdownloads.php?do=domain');
	print_stop_message('dbtech_downloads_x_y', $vbphrase['dbtech_downloads_domain'], $phrase);
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$vbulletin->input->clean_gpc('r', 'domainid', TYPE_UINT);
	
	print_cp_header(construct_phrase($vbphrase['dbtech_downloads_delete_x'], $vbphrase['dbtech_downloads_domain']));
	print_delete_confirmation('dbtech_downloads_domain', $vbulletin->GPC['domainid'], 'vbdownloads', 'domain', 'dbtech_downloads_domain', array('action' => 'kill'), '', 'domain', 'domainid');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$vbulletin->input->clean_gpc('r', 'domainid', TYPE_UINT);
	
	if (!$existing = VBDOWNLOADS::$cache['domain'][$vbulletin->GPC['domainid']])
	{
		// Couldn't find the domain
		print_stop_message('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_domain'], $vbulletin->GPC['domainid']);
	}
	
	// init data manager
	$dm =& VBDOWNLOADS::initDataManager('Domain', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	define('CP_REDIRECT', 'vbdownloads.php?do=domain');
	print_stop_message('dbtech_downloads_x_y', $vbphrase['dbtech_downloads_domain'], $vbphrase['dbtech_downloads_deleted']);	
}

print_cp_footer();